/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.api.VWWorkObjectNumber;
import filenet.vw.api.VWWorkflowHistory;
import java.util.Date;
import java.util.Vector;

public final class VWStepOccurrenceHistory {
    public static final int STATUS_COMPLETED = 0;
    public static final int STATUS_IN_PROGRESS = 1;
    public static final int STATUS_DELETED = 2;
    public static final int STATUS_EXCEPTION = 3;
    public static final int STATUS_GOTO_SUBMAP = 4;
    private long m_receivingTime = -1L;
    private long m_completionTime = -1L;
    private int m_status = 1;
    private VWStepHistory m_stepHistory = null;
    private int m_occurrenceId = 0;
    private Vector m_workObjectHistory = new Vector();
    private int m_index = 0;
    private boolean m_bInitialized = false;
    private boolean m_bInitializing = false;
    private boolean m_isFWorkFlowNumberIndex = false;
    private boolean m_bRetrieved = false;
    private VWLog m_eventLog;
    private VWLogQuery m_logQuery = null;
    private int m_bufferSize = 50;
    private boolean isFWorkFlowNumberIndex = false;
    private Vector m_logElements = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date: 2010-05-07 17:49:48 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Lauren Nguyen;5D5845897;laurenng@us.ibm.com (lnguyen) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/2 $";
    }

    VWStepOccurrenceHistory(VWStepHistory stepHistory, int occurId) throws VWException {
        this.m_stepHistory = stepHistory;
        this.m_occurrenceId = occurId;
        this.m_bInitialized = false;
    }

    public void setBufferSize(int newSize) throws VWException {
        if (newSize < 1 && this.m_bufferSize < 1) {
            throw new VWException("vw.api.SOHBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.m_bufferSize = newSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public void resetFetch() throws VWException {
        this.initialize();
        this.m_index = this.m_workObjectHistory.size() > 0 ? 0 : -1;
    }

    public boolean hasNext() throws VWException {
        this.initialize();
        if (this.m_index != -1 && this.m_index < this.m_workObjectHistory.size()) {
            if (this.m_workObjectHistory.size() > 0) {
                VWStepWorkObjectHistory woHistory = (VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(this.m_index);
                if (this.isRendezvous(this.m_index) && woHistory.getStatus() != 3) {
                    ++this.m_index;
                    return this.hasNext();
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public VWStepWorkObjectHistory next() throws VWException {
        this.initialize();
        if (this.m_index < this.m_workObjectHistory.size()) {
            VWStepWorkObjectHistory woHistory;
            if ((woHistory = (VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(this.m_index++)) != null) {
                woHistory.initialize();
            }
            this.hasNext();
            return woHistory;
        }
        return null;
    }

    void addLogElement(VWLogElement logElement) {
        try {
            String wobNum = logElement.getWorkObjectNumber();
            VWStepWorkObjectHistory wobHistory = null;
            boolean bFound = false;
            for (int i = 0; i < this.m_workObjectHistory.size(); ++i) {
                Object obj = this.m_workObjectHistory.elementAt(i);
                if (!(obj instanceof VWStepWorkObjectHistory) || wobNum.compareTo((wobHistory = (VWStepWorkObjectHistory)obj).getWorkObjectNumber()) != 0) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                wobHistory = new VWStepWorkObjectHistory(this, wobNum);
                this.m_workObjectHistory.addElement(wobHistory);
            }
            this.m_logElements.addElement(logElement);
            wobHistory.addLogElement(logElement);
        }
        catch (VWException vWException) {
            // empty catch block
        }
    }

    public String getOperationName() throws VWException {
        VWLogElement logElement = (VWLogElement)this.m_logElements.firstElement();
        if (logElement != null) {
            return logElement.getOperationName();
        }
        return null;
    }

    VWStepHistory getStepHistory() {
        return this.m_stepHistory;
    }

    VWWorkflowHistory getWorkflowHistory() {
        return this.m_stepHistory.getWorkflowHistory();
    }

    public int getOccurrenceId() {
        return this.m_occurrenceId;
    }

    void updateReceivingTime(long time) {
        if (this.m_receivingTime == -1L || time < this.m_receivingTime) {
            this.m_receivingTime = time;
            this.m_stepHistory.updateReceivingTime(time);
        }
    }

    boolean getIsCompleted() throws VWException {
        this.initialize();
        if (this.m_completionTime == -1L) {
            this.getCompletionTime();
        }
        return this.m_completionTime != -1L;
    }

    long getCompletionTime() throws VWException {
        this.initialize();
        boolean bInProcess = false;
        boolean bCompleted = false;
        boolean bDeleted = false;
        boolean bException = false;
        boolean bGotoSubmap = false;
        if (this.m_completionTime == -1L) {
            long completionTime = -1L;
            block7: for (int i = 0; i < this.m_workObjectHistory.size(); ++i) {
                int woStatus = ((VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(i)).getStatus();
                if (this.isRendezvous(i) && woStatus != 3) continue;
                long time = ((VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(i)).getCompletionTime();
                if (time == -1L) {
                    completionTime = -1L;
                    bInProcess = true;
                }
                if (time > completionTime) {
                    completionTime = time;
                }
                switch (woStatus) {
                    case 1: {
                        bInProcess = true;
                        continue block7;
                    }
                    case 2: {
                        bDeleted = true;
                        continue block7;
                    }
                    case 0: {
                        bCompleted = true;
                        continue block7;
                    }
                    case 3: {
                        bException = true;
                        continue block7;
                    }
                    case 4: {
                        bGotoSubmap = true;
                    }
                }
            }
            this.m_completionTime = completionTime;
            this.m_status = bException ? 3 : (bGotoSubmap ? 4 : (bInProcess ? 1 : (bCompleted ? 0 : (bDeleted ? 2 : 1))));
        }
        return this.m_completionTime;
    }

    void initialize() throws VWException {
        if (this.m_bInitializing || this.m_bInitialized) {
            return;
        }
        try {
            Object[] subVars;
            this.m_bInitializing = true;
            VWWorkflowHistory workflowHistory = this.getWorkflowHistory();
            String workFlowNumber = workflowHistory.getWorkflowNumber();
            int instructionSheetId = workflowHistory.getInstructionSheetId();
            int stepId = this.getStepHistory().getStepId();
            this.m_eventLog = this.getSession().fetchEventLog(this.getEventLogName());
            this.m_eventLog.setBufferSize(this.m_bufferSize);
            boolean isIndex = false;
            String indexName = null;
            String sWorkOrderIdFilter = null;
            if (this.m_stepHistory.isCompoundStep()) {
                VWInstructionDefinition[] instructionDef = this.m_stepHistory.getInstructions();
                if (instructionDef != null) {
                    boolean bStarted = false;
                    for (int i = 0; i < instructionDef.length; ++i) {
                        int action = instructionDef[i].getAction();
                        if (action == 24) continue;
                        int id = instructionDef[i].getInstructionId();
                        if (!bStarted) {
                            sWorkOrderIdFilter = "(F_WorkOrderId = " + id;
                            bStarted = true;
                            continue;
                        }
                        sWorkOrderIdFilter = sWorkOrderIdFilter + " OR F_WorkOrderId = " + id;
                    }
                    if (bStarted) {
                        sWorkOrderIdFilter = sWorkOrderIdFilter + ")";
                    }
                }
            } else {
                sWorkOrderIdFilter = "F_WorkOrderId = " + stepId;
            }
            VWLogDefinition logDef = this.m_eventLog.fetchLogDefinition();
            if (logDef != null) {
                VWIndexDefinition[] indexDefs = logDef.getIndexes();
                int count = 0;
                if (indexDefs != null) {
                    count = indexDefs.length;
                }
                for (int i = 0; i < count && !isIndex; ++i) {
                    String[] fieldNames = indexDefs[i].getAuthoredFieldNames();
                    if (fieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    indexName = indexDefs[i].getAuthoredName();
                    isIndex = true;
                }
            }
            this.isFWorkFlowNumberIndex = isIndex;
            if (isIndex) {
                Object[] subVars2;
                Object[] minValues = new Object[]{workFlowNumber};
                Object[] maxValues = new Object[]{workFlowNumber};
                if (this.m_stepHistory.getWorkflowHistory().getHistoryFilter() == 1) {
                    subVars2 = new Object[]{new Integer(instructionSheetId), new Integer(this.m_occurrenceId), new Integer(360)};
                    this.m_logQuery = stepId == 0 && instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = :a AND " + sWorkOrderIdFilter + " AND F_OccurrenceId = :b" + " AND ( " + " F_EventType = :c" + " )) ", subVars2);
                } else {
                    subVars2 = new Object[]{new Integer(instructionSheetId), new Integer(this.m_occurrenceId), new Integer(360), new Integer(370), new Integer(190), new Integer(200), new Integer(172), new Integer(174), new Integer(382), new Integer(384), new Integer(386), new Integer(170)};
                    this.m_logQuery = stepId == 0 && instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, "(F_InstrSheetId = :a AND " + sWorkOrderIdFilter + " AND F_OccurrenceId = :b" + " AND ( " + " F_EventType = :c" + " OR F_EventType = :d" + " OR F_EventType = :e" + " OR F_EventType = :f" + " OR F_EventType = :g" + " OR F_EventType = :h" + " OR F_EventType = :i" + " OR F_EventType = :j" + " OR F_EventType = :k" + " OR F_EventType = :l" + " ) )", subVars2);
                }
            } else if (this.m_stepHistory.getWorkflowHistory().getHistoryFilter() == 1) {
                subVars = new Object[]{new VWWorkObjectNumber(workFlowNumber), new Integer(instructionSheetId), new Integer(this.m_occurrenceId), new Integer(360)};
                indexName = "F_LogTime";
                this.m_logQuery = stepId == 0 && instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, null, null, 0, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND " + sWorkOrderIdFilter + " AND F_OccurrenceId = :c" + " AND ( " + " F_EventType = :d" + " )", subVars);
            } else {
                subVars = new Object[]{new VWWorkObjectNumber(workFlowNumber), new Integer(instructionSheetId), new Integer(this.m_occurrenceId), new Integer(360), new Integer(370), new Integer(190), new Integer(200), new Integer(172), new Integer(174), new Integer(382), new Integer(384), new Integer(386), new Integer(170)};
                indexName = "F_LogTime";
                this.m_logQuery = stepId == 0 && instructionSheetId == -2 ? this.m_eventLog.startQuery(indexName, null, null, 0, "(F_InstrSheetId = -2 AND  F_EventType = 140 ) ", null) : this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND F_InstrSheetId = :b AND " + sWorkOrderIdFilter + " AND F_OccurrenceId = :c" + " AND ( " + " F_EventType = :d" + " OR F_EventType = :e" + " OR F_EventType = :f" + " OR F_EventType = :g" + " OR F_EventType = :h" + " OR F_EventType = :i" + " OR F_EventType = :j" + " OR F_EventType = :k" + " OR F_EventType = :l" + " OR F_EventType = :m" + " )", subVars);
            }
            while (this.m_logQuery.hasNext()) {
                VWLogElement logElement = this.m_logQuery.next();
                if (logElement == null) continue;
                Object obj = logElement.getFieldValue("F_WPClassId");
                int queueId = -1;
                if (obj != null && obj instanceof Integer) {
                    queueId = (Integer)obj;
                }
                int operationId = -1;
                obj = logElement.getFieldValue("F_OperationId");
                if (obj != null && obj instanceof Integer) {
                    operationId = (Integer)obj;
                }
                if (operationId == -1 && queueId == -6 || operationId == 19 && queueId == -5) continue;
                this.addLogElement(logElement);
            }
        }
        catch (VWException ex) {
            this.m_bInitializing = false;
            throw ex;
        }
        this.m_bInitializing = false;
        this.m_bInitialized = true;
    }

    public int getStepId() {
        return this.m_stepHistory.getStepId();
    }

    String getWorkflowNumber() {
        return this.m_stepHistory.getWorkflowNumber();
    }

    String getEventLogName() {
        return this.m_stepHistory.getEventLogName();
    }

    public int getInstructionSheetId() {
        return this.m_stepHistory.getInstructionSheetId();
    }

    VWSession getSession() {
        return this.m_stepHistory.getSession();
    }

    public Date getDateReceived() throws VWException {
        this.initialize();
        if (this.m_receivingTime != -1L) {
            return new Date(this.m_receivingTime);
        }
        return null;
    }

    public Date getCompletionDate() throws VWException {
        this.initialize();
        if (this.getIsCompleted()) {
            return new Date(this.m_completionTime);
        }
        return null;
    }

    public int getStepStatus() throws VWException {
        this.initialize();
        this.getCompletionTime();
        return this.m_status;
    }

    void doRefresh() throws VWException {
        if (this.getCompletionDate() == null) {
            this.m_bInitialized = false;
            for (int i = 0; i < this.m_workObjectHistory.size(); ++i) {
                VWStepWorkObjectHistory woHistory = (VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(i);
                if (woHistory == null) continue;
                woHistory.doRefresh();
            }
        }
    }

    boolean isRendezvous(int i) {
        VWStepWorkObjectHistory woHistory;
        if (this.m_workObjectHistory.size() > 1 && i < this.m_workObjectHistory.size() && (woHistory = (VWStepWorkObjectHistory)this.m_workObjectHistory.elementAt(i)) != null) {
            return !woHistory.getIsAnyBoundUser();
        }
        return false;
    }
}

